#!/bin/bash

FOLDER_TO_WATCH="/var/www/html/disk"
LOG_FILE="/home/orangepi/my_disk_changes.log"

# Формат виводу: [Час] Подія Папка/Файл
FORMAT_STRING='[%T] %e %w%f'

echo "--- Starting monitoring of $FOLDER_TO_WATCH at $(date) ---" >> "$LOG_FILE"

inotifywait -m -r "$FOLDER_TO_WATCH" \
            --timefmt '%Y-%m-%d %H:%M:%S' \
            --format "$FORMAT_STRING" \
            -e create,modify,delete,move |
while read line; do
    # Записуємо кожну подію в лог-файл
    echo "$line" >> "$LOG_FILE"
done
~     
